USE LigaKreglarskaZmiana;
GO

CREATE PROCEDURE R15_oblicz_sredni_hcp_wedlug_liczby_kregli
AS 
UPDATE    Kreglarze
SET              LiczbaZbitychKregli =
                          (SELECT     SUM(WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), LiczbaRozegranychGier =
                          (SELECT     COUNT(Wyniki_kreglarzy.WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), BiezacaSredniaKreglarza =
                          IsNull((SELECT     Round(AVG(Wyniki_kreglarzy.WynikCzysty), 0)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), 0), BiezacyHandicapKreglarza =
                          IsNull((SELECT     Round(0.9 * (200 - Round(AVG(Wyniki_kreglarzy.WynikCzysty), 0)), 0)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), 0);
GO

CREATE VIEW R15_oblicz_sredni_hcp_wedlug_liczby_kregli_zapytanie
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.LiczbaZbitychKregli, 
                          (SELECT     SUM(WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) 
AS NowaLiczbaZbitychKregli, Kreglarze.LiczbaRozegranychGier, 
                          (SELECT     COUNT(Wyniki_kreglarzy.WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) 
AS NowaLiczbaRozegranychGier, Kreglarze.BiezacaSredniaKreglarza, 
                          IsNull((SELECT     Round(AVG(Wyniki_kreglarzy.WynikCzysty), 0)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), 0) 
AS NowaBiezacaSredniaKreglarza, Kreglarze.BiezacyHandicapKreglarza, 
                          IsNull((SELECT     Round(0.9 * (200 - Round(AVG(Wyniki_kreglarzy.WynikCzysty), 0)), 0)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), 0) 
AS NowyBiezacyHandicapKreglarza
FROM Kreglarze;
GO

CREATE PROCEDURE R15_zmiana_nazwy_druzyny_Huckleberrys
AS 
UPDATE    Druzyny
SET              NazwaDruzyny = 'Manta Rays'
WHERE     (NazwaDruzyny = 'Huckleberrys');
GO

CREATE VIEW R15_zmiana_nazwy_druzyny_Huckleberrys_zapytanie
AS 
SELECT Druzyny.NazwaDruzyny, 'Manta Rays' AS NowaNazwaDruzyny
FROM Druzyny
WHERE Druzyny.NazwaDruzyny = 'Huckleberrys';
GO

CREATE PROCEDURE R15_zmiana_lokalizacji_turnieju
AS 
UPDATE    Turnieje
SET              LokalizacjaTurnieju = 'Oasis Lanes'
WHERE     (LokalizacjaTurnieju = 'Sports World Lanes');
GO

CREATE VIEW R15_zmiana_lokalizacji_turnieju_zapytanie
AS 
SELECT Turnieje.IDTurnieju, Turnieje.LokalizacjaTurnieju, 'Oasis Lanes' AS NowaLokalizacjaTurnieju
FROM Turnieje
WHERE (Turnieje.LokalizacjaTurnieju = 'Sports World Lanes');
GO

CREATE PROCEDURE R15_zaktualizuj_stan_i_miasto_zamieszkania_kreglarzy
AS 
UPDATE    Kreglarze
SET              MiastoKreglarza =
                          (SELECT     Miasto
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod), StanZamKreglarza =
                          (SELECT     Stan
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod)
WHERE     (MiastoKreglarza <>
                          (SELECT     Miasto
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod)) OR
                      (StanZamKreglarza <>
                          (SELECT     Stan
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod));
GO

CREATE VIEW R15_zaktualizuj_stan_i_miasto_zamieszkania_kreglarzy_zapytanie
AS 
SELECT Kreglarze.MiastoKreglarza, 
                          (SELECT     Miasto
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod) AS NoweMiastoKreglarza, Kreglarze.StanZamKreglarza, 
                          (SELECT     Stan
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod) AS NowyStanZamKreglarza
FROM Kreglarze
WHERE     (MiastoKreglarza <>
                          (SELECT     Miasto
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod)) OR
                      (StanZamKreglarza <>
                          (SELECT     Stan
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod));
GO

CREATE PROCEDURE R16_dodaj_kreglarza
AS 
INSERT INTO Kreglarze
                      (NazwiskoKreglarza, ImieKreglarza, AdresKreglarza, MiastoKreglarza, StanZamKreglarza, KodPocztowyKreglarza, TelefonKreglarza, IDDruzyny, LiczbaZbitychKregli, 
                      LiczbaRozegranychGier, BiezacaSredniaKreglarza, BiezacyHandicapKreglarza)
SELECT     NazwiskoKreglarza, 'Matthew' AS ImieKreglarza, AdresKreglarza, MiastoKreglarza, StanZamKreglarza, KodPocztowyKreglarza, TelefonKreglarza, IDDruzyny, 0 AS LiczbaZbitychKregli, 0 AS LiczbaRozegranychGier, 0 AS BolwerCurrentAverage, 0 AS BiezacyHandicapKreglarza
FROM         Kreglarze
WHERE     (NazwiskoKreglarza = 'Patterson') AND (ImieKreglarza = 'Neil');
GO

CREATE VIEW R16_dodaj_kreglarza_zapytanie
AS 
SELECT Kreglarze.NazwiskoKreglarza, 'Matthew' AS ImieKreglarza, Kreglarze.AdresKreglarza, Kreglarze.MiastoKreglarza, Kreglarze.StanZamKreglarza, Kreglarze.KodPocztowyKreglarza, Kreglarze.TelefonKreglarza, Kreglarze.IDDruzyny, 0 AS LiczbaZbitychKregli, 0 AS LiczbaRozegranychGier, 0 AS BiezacaSredniaKreglarza, 0 AS BiezacyHandicapKreglarza
FROM Kreglarze
WHERE (((Kreglarze.NazwiskoKreglarza)='Patterson') AND ((Kreglarze.ImieKreglarza)='Neil'));
GO

CREATE PROCEDURE R16_dodaj_druzyne
AS 
INSERT INTO Druzyny
                      (NazwaDruzyny, IDKapitana)
VALUES     ('Aardvarks', NULL);
GO

CREATE VIEW R16_dodaj_druzyne_zapytanie
AS
SELECT 'Aardvarks' As NazwaDruzyny, Null As IDKapitana;
GO

CREATE PROCEDURE R16_zarchiwizuj_turnieje_2017_1
AS 
INSERT INTO Turnieje_archiwum
SELECT     IDTurnieju, DataTurnieju, LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017');
GO

CREATE VIEW R16_zarchiwizuj_turnieje_2017_1_zapytanie
AS 
SELECT     IDTurnieju, DataTurnieju, LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017');
GO

CREATE PROCEDURE R16_zarchiwizuj_turnieje_2017_2
AS 
INSERT INTO Mecze_turniejowe_archiwum
SELECT     IDMeczu, IDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty
FROM         Mecze_turniejowe
WHERE     (IDTurnieju IN
                          (SELECT     IDTurnieju
                            FROM          Turnieje
                            WHERE      DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017'));
GO

CREATE VIEW R16_zarchiwizuj_turnieje_2017_2_zapytanie
AS 
SELECT     IDMeczu, IDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty
FROM         Mecze_turniejowe
WHERE     (IDTurnieju IN
                          (SELECT     IDTurnieju
                            FROM          Turnieje
                            WHERE      DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017'));
GO

CREATE PROCEDURE R16_zarchiwizuj_turnieje_2017_3
AS 
INSERT INTO Gry_meczowe_archiwum
SELECT     IDMeczu, NumerGry, NULL AS WinTeam
FROM         Gry_meczowe
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017'));
GO

CREATE VIEW R16_zarchiwizuj_turnieje_2017_3_zapytanie
AS 
SELECT     IDMeczu, NumerGry, NULL AS WinTeam
FROM         Gry_meczowe
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017'));
GO

CREATE PROCEDURE R16_zarchiwizuj_turnieje_2017_4
AS 
INSERT INTO Wyniki_kreglarzy_archiwum
SELECT     IDMeczu, NumerGry, IDKreglarza, WynikCzysty, WynikHandicap, GraWygrana
FROM         Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017'));
GO

CREATE VIEW R16_zarchiwizuj_turnieje_2017_4_zapytanie
AS 
SELECT     IDMeczu, NumerGry, IDKreglarza, WynikCzysty, WynikHandicap, GraWygrana
FROM         Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017'));
GO

CREATE PROCEDURE R16_skopiuj_turnieje_2017_1
AS 
SET IDENTITY_INSERT Turnieje ON
INSERT INTO Turnieje
                      (IDTurnieju, DataTurnieju, LokalizacjaTurnieju)
SELECT     IDTurnieju + 25 AS Expr1, DateAdd(d, 728, DataTurnieju) AS Expr2, LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017');
SET IDENTITY_INSERT Turnieje OFF
GO

CREATE VIEW R16_skopiuj_turnieje_2017_1_zapytanie
AS 
SELECT     IDTurnieju + 25 AS NowyIDTurnieju, DateAdd(d, 728, DataTurnieju) AS NowaDataTurnieju, LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017');
GO

CREATE PROCEDURE R16_skopiuj_turnieje_2017_2
AS 
INSERT INTO Mecze_turniejowe
                      (IDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty)
SELECT     IDTurnieju + 25 AS NowyIDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty
FROM         Mecze_turniejowe
WHERE Mecze_turniejowe.IDTurnieju IN
(SELECT IDTurnieju 
 FROM Turnieje
 WHERE Turnieje.DataTurnieju Between '1/1/2017' And '12/31/2017');
GO

CREATE VIEW R16_skopiuj_turnieje_2017_2_zapytanie
AS 
SELECT     IDMeczu, IDTurnieju + 25 AS NowyIDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty
FROM         Mecze_turniejowe
WHERE Mecze_turniejowe.IDTurnieju IN
(SELECT IDTurnieju 
 FROM Turnieje
 WHERE Turnieje.DataTurnieju Between '1/1/2017' And '12/31/2017');
GO

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_1
AS 
DELETE FROM Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe_archiwum.IDMeczu
                            FROM          Mecze_turniejowe_archiwum));
GO

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_1_zapytanie
AS 
SELECT * FROM Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe_archiwum.IDMeczu
                            FROM          Mecze_turniejowe_archiwum));
GO

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_1_ZLE
AS 
DELETE FROM Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017'));
GO

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_1_ZLE_zapytanie
AS 
SELECT * FROM Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN '1/1/2017' AND '12/31/2017'));
GO

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_2
AS 
DELETE FROM Gry_meczowe
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe_archiwum.IDMeczu
                            FROM          Mecze_turniejowe_archiwum));
GO

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_2_zapytanie
AS 
SELECT * FROM Gry_meczowe
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe_archiwum.IDMeczu
                            FROM          Mecze_turniejowe_archiwum));
GO

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_3
AS 
DELETE FROM Mecze_turniejowe
WHERE     (IDMeczu IN
                          (SELECT     IDMeczu
                            FROM          Mecze_turniejowe_archiwum));
GO

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_3_zapytanie
AS 
SELECT * FROM Mecze_turniejowe
WHERE     (IDMeczu IN
                          (SELECT     IDMeczu
                            FROM          Mecze_turniejowe_archiwum));
GO

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_4
AS 
DELETE FROM Turnieje
WHERE     (IDTurnieju IN
                          (SELECT     Turnieje_archiwum.IDTurnieju
                            FROM          Turnieje_archiwum));
GO

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_4_zapytanie
AS 
SELECT * FROM Turnieje
WHERE     (IDTurnieju IN
                          (SELECT     Turnieje_archiwum.IDTurnieju
                            FROM          Turnieje_archiwum));
GO

CREATE PROCEDURE R17_usun_kreglarzy_bez_gier
AS 
DELETE FROM Kreglarze
WHERE     (LiczbaRozegranychGier = 0);
GO

CREATE VIEW R17_usun_kreglarzy_bez_gier_zapytanie
AS 
SELECT * FROM Kreglarze
WHERE     (LiczbaRozegranychGier = 0);
GO

CREATE PROCEDURE R17_usun_kreglarzy_bez_gier_bezpiecznie
AS 
DELETE FROM dbo.Kreglarze
WHERE     (IDKreglarza NOT IN
                          (SELECT     IDKreglarza
                            FROM          Wyniki_kreglarzy));
GO

CREATE VIEW R17_usun_kreglarzy_bez_gier_bezpiecznie_zapytanie
AS 
SELECT * FROM dbo.Kreglarze
WHERE     (IDKreglarza NOT IN
                          (SELECT     IDKreglarza
                            FROM          Wyniki_kreglarzy));
GO

CREATE PROCEDURE R17_usun_mecze_ktore_sie_nie_odbyly
AS 
DELETE FROM Mecze_turniejowe
WHERE     (IDMeczu NOT IN
                          (SELECT     IDMeczu
                            FROM          Wyniki_kreglarzy))
	AND   (IDMeczu NOT IN
                          (SELECT     IDMeczu
                            FROM          Gry_meczowe));
GO

CREATE VIEW R17_usun_mecze_ktore_sie_nie_odbyly_zapytanie
AS 
SELECT * FROM Mecze_turniejowe
WHERE     (IDMeczu NOT IN
                          (SELECT     IDMeczu
                            FROM          Wyniki_kreglarzy))
	AND   (IDMeczu NOT IN
                          (SELECT     IDMeczu
                            FROM          Gry_meczowe));
GO

